% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ge_model.R
\name{ge_model}
\alias{ge_model}
\alias{ge_model.default}
\title{Genotype by Environment Interaction Model}
\usage{
ge_model(.data, .y, .gen, .env, .rep)

\method{ge_model}{default}(.data, .y, .gen, .env, .rep)
}
\arguments{
\item{.data}{data.frame}

\item{.y}{Response Variable}

\item{.gen}{Genotypes Factor}

\item{.env}{Environment Factor}

\item{.rep}{Replication Factor}
}
\value{
Genotype by Environment Interaction Model
}
\description{
Calcuates Genotype by Environment Interaction Model
}
\examples{

data(cultivo2008)
fm1 <-
   ge_model(
      .data  = cultivo2008
     , .y    = y
     , .gen  = entry
     , .env  = site
     , .rep  = rep
     )


}
\references{
Perez-Elizalde, S., Jarquin, D., and Crossa, J. (2011)
 A General Bayesian Estimation Method of Linear–Bilinear Models
 Applied to Plant Breeding Trials With Genotype × Environment Interaction.
 \emph{Journal of Agricultural, Biological, and Environmental Statistics},
  17, 15–37.  (\href{https://link.springer.com/article/10.1007/s13253-011-0063-9}{doi:10.1007/s13253-011-0063-9})
}
\author{
\enumerate{
    \item Muhammad Yaseen (\email{myaseen208@gmail.com})
   }
}
