\name{logdensity}
\alias{logdensity}
\title{
Calculate an estimate of log posterior ordinate used in the log marginal density of Chib (1995).
}
\description{
Log marginal likelihood = Log likelihood + Log prior - Log density
}
\usage{
logdensity(tau2, cpost)
}
\arguments{
  \item{tau2}{Square of re-parameterized bandwidths and square of normal error variance}
  \item{cpost}{Simulation output of \code{tau2} obtained from the MCMC iterations}
}
\details{
It should be noted that the posterior mode or maximum likelihood estimate can be computed from the 
simulation output at least approximately, if it is easy to evaluate the log-likelihood function for each draw
in the simulation. Alternatively, one can make use of the posterior mean provided that there is no
concern that it is a low density point.
}
\value{
Value of the log density
}
\references{
S. Chib (1995) Marginal likelihood from the Gibbs output, \emph{Journal of the American Statistical Association}, \bold{90}, 432, 1313-1321.

M. A. Newton and A. E. Raftery (1994) Approximate Bayesian inference by the weighted likelihood bootstrap (with discussion), \emph{Journal of 
the Royal Statistical Society}, \bold{56}, 3-48.
}
\author{
Han Lin Shang
}
\seealso{
\code{\link[bbemkr]{logpriors}}, \code{\link[bbemkr]{loglikelihood}}, \code{\link[bbemkr]{mcmcrecord}}
}
\keyword{methods}

