% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{dPosteriorPredictive.GaussianNIG}
\alias{dPosteriorPredictive.GaussianNIG}
\title{Posterior predictive density function of a "GaussianNIG" object}
\usage{
\method{dPosteriorPredictive}{GaussianNIG}(obj, x, X, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "GaussianNIG" object.}

\item{x}{numeric, must satisfy length(x) = nrow(X).}

\item{X}{matrix, must satisfy length(x) = nrow(X).}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A numeric vector, the posterior predictive density.
}
\description{
Generate the the density value of the posterior predictive distribution of the following structure: \cr
     beta,sigma^2|gamma ~ NIG(gamma) \cr
     x|beta,sigma^2,X ~ Gaussian(X%*%beta,sigma^2) \cr
where gamma = (m,V,a,b) is the Normal-Inverse-Gamma(NIG) parameter, "m" is a numeric "location" parameter; "V" is a symmetric positive definite matrix representing the "scale" parameters; "a" and "b" are the "shape" and "rate" parameter of the Inverse Gamma distribution. \cr
The model structure and prior parameters are stored in a "GaussianNIG" object. \cr
Posterior predictive is the distribution of x|gamma,X.
}
\examples{
obj <- GaussianNIG(gamma=list(m=0,V=1,a=1,b=1))
X <- 1:20
x <- rnorm(20)+ X*0.3
## out1 and out2 it should have the same values:
out1 <- dPosteriorPredictive(obj = obj, x = x,X=X,LOG = TRUE)
out2 <- numeric(length(x))
for(i in 1:length(x))
out2[i] <- marginalLikelihood(obj,x=x[i],X=X[i],LOG = TRUE)
max(abs(out1-out2))
}
\references{
Banerjee, Sudipto. "Bayesian Linear Model: Gory Details." Dowloaded from http://www. biostat. umn. edu/~ ph7440 (2008).
}
\seealso{
@seealso \code{\link{GaussianNIG}}, \code{\link{dPosteriorPredictive.GaussianNIG}}, \code{\link{marginalLikelihood.GaussianNIG}}
}
