% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{rPosteriorPredictive.GaussianNIG}
\alias{rPosteriorPredictive.GaussianNIG}
\title{Posterior predictive random generation of a "GaussianNIG" object}
\usage{
\method{rPosteriorPredictive}{GaussianNIG}(obj, n, X, ...)
}
\arguments{
\item{obj}{A "GaussianNIG" object.}

\item{n}{integer, number of samples.}

\item{X}{matrix, the location of the prediction, each row is a location.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A matrix of n rows and nrow(X) columns, each row is a sample.
}
\description{
Generate random samples from the posterior predictive distribution of the following structure: \cr
     beta,sigma^2|gamma ~ NIG(gamma) \cr
     x|beta,sigma^2,X ~ Gaussian(X%*%beta,sigma^2) \cr
where gamma = (m,V,a,b) is the Normal-Inverse-Gamma(NIG) parameter, "m" is a numeric "location" parameter; "V" is a symmetric positive definite matrix representing the "scale" parameters; "a" and "b" are the "shape" and "rate" parameter of the Inverse Gamma distribution. \cr
The model structure and prior parameters are stored in a "GaussianNIG" object. \cr
Posterior predictive is a distribution of x|gamma,X.
}
\examples{
obj <- GaussianNIG(gamma=list(m=c(1,1),V=diag(2),a=1,b=1))
X <- matrix(runif(20),ncol=2)
rPosteriorPredictive(obj=obj,n=3,X=X)
}
\references{
Banerjee, Sudipto. "Bayesian Linear Model: Gory Details." Dowloaded from http://www. biostat. umn. edu/~ ph7440 (2008).
}
\seealso{
@seealso \code{\link{GaussianNIG}}, \code{\link{dPosteriorPredictive.GaussianNIG}}
}
