% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayesian_Bricks.r
\name{dPosteriorPredictive}
\alias{dPosteriorPredictive}
\title{Get the density value of the posterior predictive distribution}
\usage{
dPosteriorPredictive(obj, ...)
}
\arguments{
\item{obj}{A "BayesianBrick" object used to select a method.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
numeric, the density value
}
\description{
This is a generic function that will generate the the density value of the posterior predictive distribution. i.e. for the model structure: \cr
     \deqn{theta|gamma ~ H(gamma)}
     \deqn{x|theta ~ F(theta)}
get the probability density/mass of the posterior predictive distribution of a new sample x_new: p(x_new|gamma).
For a given Bayesian bricks object obj and a new sample x, \code{dPosteriorPredictive()} will calculate the marginal likelihood for different model structures:
\subsection{class(obj)="LinearGaussianGaussian"}{
Where
     \deqn{x ~ Gaussian(A z + b, Sigma)}
     \deqn{z ~ Gaussian(m,S)}
\code{dPosteriorPredictive()} will return p(x|m,S,A,b,Sigma)
See \code{?dPosteriorPredictive.LinearGaussianGaussian} for details.
}
\subsection{class(obj)="GaussianGaussian"}{
Where
\deqn{x ~ Gaussian(mu,Sigma)}
\deqn{mu ~ Gaussian(m,S)}
Sigma is known.
\code{dPosteriorPredictive()} will return p(x|m,S,Sigma)
See \code{?dPosteriorPredictive.GaussianGaussian} for details.
}
\subsection{class(obj)="GaussianInvWishart"}{
Where
\deqn{x ~ Gaussian(mu,Sigma)}
\deqn{Sigma ~ InvWishart(v,S)}
mu is known.
\code{dPosteriorPredictive()} will return p(x|mu,v,S)
See \code{?dPosteriorPredictive.GaussianInvWishart} for details.
}
\subsection{class(obj)="GaussianNIW"}{
Where
\deqn{x ~ Gaussian(mu,Sigma)}
\deqn{Sigma ~ InvWishart(v,S)}
\deqn{mu ~ Gaussian(m,Sigma/k)}
\code{dPosteriorPredictive()} will return p(x|m,k,v,S)
See \code{?dPosteriorPredictive.GaussianNIW} for details.
}
\subsection{class(obj)="GaussianNIG"}{
Where
\deqn{x ~ Gaussian(X beta,sigma^2)}
\deqn{sigma^2 ~ InvGamma(a,b)}
\deqn{beta ~ Gaussian(m,sigma^2 V)}
X is a row vector, or a design matrix where each row is an obervation.
\code{dPosteriorPredictive()} will return p(x,X|m,V,a,b)
See \code{?dPosteriorPredictive.GaussianNIG} for details.
}
\subsection{class(obj)="CatDirichlet"}{
Where
\deqn{x ~ Categorical(pi)}
\deqn{pi ~ Dirichlet(alpha)}
\code{dPosteriorPredictive()} will return p(x|alpha)
See \code{?dPosteriorPredictive.CatDirichlet} for details.
}
\subsection{class(obj)="CatDP"}{
Where
\deqn{x ~ Categorical(pi)}
\deqn{pi ~ DirichletProcess(alpha)}
\code{dPosteriorPredictive()} will return p(x|alpha)
See \code{?dPosteriorPredictive.CatDP} for details.
}
}
\seealso{
\code{\link{dPosteriorPredictive.LinearGaussianGaussian}} for Linear Gaussian and Gaussian conjugate structure, \code{\link{dPosteriorPredictive.GaussianGaussian}} for Gaussian-Gaussian conjugate structure, \code{\link{dPosteriorPredictive.GaussianInvWishart}} for Gaussian-Inverse-Wishart conjugate structure, \code{\link{dPosteriorPredictive.GaussianNIW}} for Gaussian-NIW conjugate structure, \code{\link{dPosteriorPredictive.GaussianNIG}} for Gaussian-NIG conjugate structure, \code{\link{dPosteriorPredictive.CatDirichlet}} for Categorical-Dirichlet conjugate structure, \code{\link{dPosteriorPredictive.CatDP}} for Categorical-DP conjugate structure ...
}
