% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Categorical_Inference.r
\name{dPosterior.CatDirichlet}
\alias{dPosterior.CatDirichlet}
\title{Density function of the posterior distribution of a "CatDirichlet" object}
\usage{
\method{dPosterior}{CatDirichlet}(obj, pi, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "CatDirichlet" object.}

\item{pi}{matrix or a numeric vector. When pi is a matrix, each row is an observation. When pi is a vector, it will be treated as only one observation.}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
numeric vector, the posterior densities for each row of pi.
}
\description{
Generate the the density value of the posterior distribution of the following structure:
     \deqn{pi|alpha \sim Dir(alpha)}
     \deqn{x|pi \sim Categorical(pi)}
Where Dir() is the Dirichlet distribution, Categorical() is the Categorical distribution. See \code{?dDir} and \code{dCategorical} for the definitions of these distribution. \cr
The model structure and prior parameters are stored in a "CatDirichlet" object. \cr
Posterior density is the density function of Dir(pi|alpha).
}
\examples{
obj <- CatDirichlet(gamma=list(alpha=runif(26),uniqueLabels = letters))
dPosterior(obj = obj,pi = runif(26))
dPosterior(obj = obj,pi = matrix(runif(26*10),nrow = 10))
}
\seealso{
\code{\link{CatDirichlet}}, \code{\link{rPosterior.CatDirichlet}}
}
