% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{dPosteriorPredictive.GaussianGaussian}
\alias{dPosteriorPredictive.GaussianGaussian}
\title{Posterior predictive density function of a "GaussianGaussian" object}
\usage{
\method{dPosteriorPredictive}{GaussianGaussian}(obj, x, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "GaussianGaussian" object.}

\item{x}{matrix, or the ones that can be converted to matrix, each row of x is an observation.}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A numeric vector of the same length as nrow(x), the posterior predictive density.
}
\description{
Generate the the density value of the posterior predictive distribution of the following structure:
     \deqn{x \sim Gaussian(mu,Sigma)}
     \deqn{mu \sim Gaussian(m,S)}
Where Sigma is known. Gaussian() is the Gaussian distribution. See \code{?dGaussian} for the definition of Gaussian distribution.\cr
The model structure and prior parameters are stored in a "GaussianGaussian" object. \cr
Posterior predictive density is p(x|m,S,Sigma).
}
\examples{
obj <- GaussianGaussian(gamma=list(Sigma=matrix(c(2,1,1,2),2,2),m=c(0.2,0.5),S=diag(2)))
x <- rGaussian(100,c(0,0),Sigma = matrix(c(2,1,1,2),2,2))
dPosteriorPredictive(obj = obj,x=x,LOG = TRUE)
dPosteriorPredictive(obj = obj,x=x,LOG = FALSE)
}
\references{
Gelman, Andrew, et al. Bayesian data analysis. CRC press, 2013.
}
\seealso{
\code{\link{GaussianGaussian}}, \code{\link{dPosteriorPredictive.GaussianGaussian}}, \code{\link{marginalLikelihood.GaussianGaussian}}
}
