% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayesian_Bricks.r
\name{marginalLikelihood}
\alias{marginalLikelihood}
\title{Get the marginal likelihood of a "BayesianBrick" object}
\usage{
marginalLikelihood(obj, ...)
}
\arguments{
\item{obj}{A "BayesianBrick" object used to select a method.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
numeric, the marginal likelihood
}
\description{
This is a generic function that will generate the marginal likelihood of a set of observations conditioned on a given "BayesianBrick" object. i.e. for the model structure: \cr
     \deqn{theta|gamma \sim H(gamma)}
     \deqn{x|theta \sim F(theta)}
Marginal likelihood is p(x|gamma), p() is the probability density/mass function for continuous/discrete x.
For a given Bayesian bricks object obj and a sample set x, \code{marginalLikelihood()} will calculate the marginal likelihood for different model structures:
\subsection{class(obj)="LinearGaussianGaussian"}{
Where
     \deqn{x \sim Gaussian(A z + b, Sigma)}
     \deqn{z \sim Gaussian(m,S)}
\code{marginalLikelihood()} will return p(x|m,S,A,b,Sigma)
See \code{?marginalLikelihood.LinearGaussianGaussian} for details.
}
\subsection{class(obj)="GaussianGaussian"}{
Where
\deqn{x \sim Gaussian(mu,Sigma)}
\deqn{mu \sim Gaussian(m,S)}
Sigma is known.
\code{marginalLikelihood()} will return p(x|m,S,Sigma)
See \code{?marginalLikelihood.GaussianGaussian} for details.
}
\subsection{class(obj)="GaussianInvWishart"}{
Where
\deqn{x \sim Gaussian(mu,Sigma)}
\deqn{Sigma \sim InvWishart(v,S)}
mu is known.
\code{marginalLikelihood()} will return p(x|mu,v,S)
See \code{?marginalLikelihood.GaussianInvWishart} for details.
}
\subsection{class(obj)="GaussianNIW"}{
Where
\deqn{x \sim Gaussian(mu,Sigma)}
\deqn{Sigma \sim InvWishart(v,S)}
\deqn{mu \sim Gaussian(m,Sigma/k)}
\code{marginalLikelihood()} will return p(x|m,k,v,S)
See \code{?marginalLikelihood.GaussianNIW} for details.
}
\subsection{class(obj)="GaussianNIG"}{
Where
\deqn{x \sim Gaussian(X beta,sigma^2)}
\deqn{sigma^2 \sim InvGamma(a,b)}
\deqn{beta \sim Gaussian(m,sigma^2 V)}
X is a row vector, or a design matrix where each row is an obervation.
\code{marginalLikelihood()} will return p(x,X|m,V,a,b)
See \code{?marginalLikelihood.GaussianNIG} for details.
}
\subsection{class(obj)="CatDirichlet"}{
Where
\deqn{x \sim Categorical(pi)}
\deqn{pi \sim Dirichlet(alpha)}
\code{marginalLikelihood()} will return p(x|alpha)
See \code{?marginalLikelihood.CatDirichlet} for details.
}
\subsection{class(obj)="CatDP"}{
Where
\deqn{x \sim Categorical(pi)}
\deqn{pi \sim DirichletProcess(alpha)}
\code{marginalLikelihood()} will return p(x|alpha)
See \code{?marginalLikelihood.CatDP} for details.
}
}
\seealso{
\code{\link{marginalLikelihood.LinearGaussianGaussian}} for Linear Gaussian and Gaussian conjugate structure, \code{\link{marginalLikelihood.GaussianGaussian}} for Gaussian-Gaussian conjugate structure, \code{\link{marginalLikelihood.GaussianInvWishart}} for Gaussian-Inverse-Wishart conjugate structure, \code{\link{marginalLikelihood.GaussianNIW}} for Gaussian-NIW conjugate structure, \code{\link{marginalLikelihood.GaussianNIG}} for Gaussian-NIG conjugate structure, \code{\link{marginalLikelihood.CatDirichlet}} for Categorical-Dirichlet conjugate structure, \code{\link{marginalLikelihood.CatDP}} for Categorical-DP conjugate structure ...
}
