% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch-bbs-data.R
\name{fetch_bbs_data}
\alias{fetch_bbs_data}
\title{Fetch Breeding Bird Survey dataset}
\usage{
fetch_bbs_data(level = "state", quiet = FALSE, force = FALSE)
}
\arguments{
\item{level}{A string, either "state" or "stop", specifying which counts to
fetch. Defaults to "state", which provides counts beginning in 1966,
aggregated in five bins, each of which contains cumulative counts from 10 of
the 50 stops along a route. Specifying "stop" provides stop-level data
beginning in 1997, which includes counts for each stop along routes
individually. Note that stop-level data is not currently supported by
the modeling utilities in bbsBayes.}

\item{quiet}{Logical: should progress bars be suppressed? Defaults to FALSE}

\item{force}{Logical: if BBS data already exists on computer, should it be overwritten? Defaults to FALSE}
}
\value{
None
}
\description{
\code{fetch_bbs_data} uses File Transfer Protocol (FTP) to fetch Breeding Bird
 Survey data from the United States Geological Survey (USGS) FTP site. This
 is the raw data that is uploaded to the site before any analyses are performed.
 A package-specific directory is created on the user's computer and the BBS
 data is saved to that directory for use by other functions.
 Before downloading any data, the user must thoroughly read through the terms
 and conditions of the user of the data and type the word "yes" to agree.
}
