# Copyright 2019 Province of British Columbia
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and limitations under the License.

is_filetype <- function(x, ext) {
  tools::file_ext(x) %in% ext
}

is_emptyish <- function(x) {
  length(x) == 0 || !nzchar(x)
}


is_whse_object_name <- function(x) {

  ## detect object is a record and then just return FALSE
  if (inherits(x, "bcdc_record")) {
    return(FALSE)
  }

  grepl("^[A-Z_]+\\.[A-Z_]+$", x)
}

is_record <- function(x) {
  class(x) == "bcdc_record"
}
