% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_incr_conc.R
\name{sm.incr.conc}
\alias{sm.incr.conc}
\title{Specify a smooth, increasing and concave shape-restriction in a \pkg{bcgam} formula}
\usage{
sm.incr.conc(x, numknots = 0, knots = 0, space = "Q")
}
\arguments{
\item{x}{a numeric predictor of length \eqn{n}.}

\item{numknots}{number of knots used to constrain \code{x}. It is ignored when the \code{knots}
argument is specified by the user. If neither \code{numknots} nor \code{knots} are specified by the user,
then \code{numknots} is \eqn{floor{4+n^(1/7)}}. The default is \code{0}.}

\item{knots}{knots used to constrain \code{x}. If they are not specified by the user, then they will 
be automatically created based on \code{numknots} and \code{space}. The default is \code{0}.}

\item{space}{a character specifying the method to create knots. It is ignored when the \code{knots}
argument is specified by the user. If \code{space="E"}, then equally spaced knots will be created; 
if \code{space="Q"}, then a vector of equal quantiles will be created based on \code{x}
with duplicate elements removed. The default is \code{"Q"}.}
}
\value{
\item{x}{The numeric predictor \code{x}.}
}
\description{
A symbolic routine to define that the systematic component \eqn{\eta} is
smooth, increasing and concave with respect to a predictor in a bcgam formula.
}
\details{
\code{sm.incr.conc} returns the vector \code{x} and assigns five attributes to it: name, shape (1 for  
"smooth, increasing and concave"), numknots, knots and space. 

This routine does not create the splines basis vectors by itself.
}
\examples{
data(duncan)

prestige <- duncan$prestige

# specify knots
sm.incr.conc(prestige, knots=c(3,9,30,57,86,97))

# specify number of knots
prestige.smincrconc <- sm.incr.conc(prestige, numknots=7)

# check attributes
attributes(prestige.smincrconc)
}
\references{
Meyer, M. C. (2008) Inference using shape-restricted regression splines. 
\emph{Annals of Applied Statistics} \strong{2(3)}, 1013-1033.
}
\author{
Cristian Oliva-Aviles and Mary C. Meyer
}
