% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_by_variable.R
\name{get_data_by_variable}
\alias{get_data_by_variable}
\title{Get data by variable Id from BDL API}
\usage{
get_data_by_variable(
  varId,
  unitParentId = NULL,
  unitLevel = NULL,
  year = NULL,
  aggregateId = NULL,
  lang = c("pl", "en"),
  ...
)
}
\arguments{
\item{varId}{A single variable Id or vector of multiple variable id's. If multiple id's are used, some columns
are not available. Use \code{\link{search_variables}} or \code{\link{get_variables}} to find variable id code.}

\item{unitParentId}{A 12 character NUTS id code of parent unit. Use \code{\link{search_units}} or
\code{\link{get_units}} to find unit id code. If \code{NULL} (default) and \code{unitLevel} not
set up, returns all available units for variable.}

\item{unitLevel}{A number from 0 to 6, filters the returned unit by its level.
If \code{NULL} (default) no level filters apply. Use \code{\link{get_levels}} to find more info.}

\item{year}{A vector of years. If \code{NULL} (default) returns data for all available years.}

\item{aggregateId}{An aggregate id. Use \code{\link{get_aggregates}} for more info.}

\item{lang}{A language of returned data, "pl" (default), "en"}

\item{...}{Other arguments passed on to \code{\link[httr]{GET}}. For example
a proxy parameters, see details.}
}
\value{
A dataset as a tibble.
}
\description{
Retrieve data for a given variable for multiple units
 from BDL with specified format.
}
\details{
Data to retrieve from
  \href{https://bdl.stat.gov.pl}{The
  BDL Web Services} can be filtered with arguments. To get JSON data from specified
  directory with custom filters use \code{\link{get_request}} directly.

  To use a proxy to connect, a \code{\link[httr]{use_proxy}} can be
  passed to \code{\link[httr]{GET}}. For example
  \code{get_request(id, filters,
  config = httr::use_proxy(url, port, username, password))}.
}
\examples{
   # get_data_by_variable(varId = "3643", unitParentId = "030200000000")
   # get_data_by_variable("420", year = "2000", unitLevel = 6)
   
   # Multi variable download
   # get_data_by_variable(varId =c("415","420"), unitParentId = "030210423000")
}
\keyword{database}
\keyword{utilities}
