% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContractionPipe.R
\docType{class}
\name{ContractionPipe}
\alias{ContractionPipe}
\title{Class to find and/or replace the contractions on the data field of a Instance}
\usage{
ContractionPipe
}
\description{
\code{\link{ContractionPipe}} class is responsible for detecting
the existing contractions in the \strong{data} field of each \code{\link{Instance}}.
Identified contractions are stored inside the \strong{contraction} field of
\code{\link{Instance}} class. Moreover if needed, is able to perform inline
contractions replacement.
}
\section{Constructor}{

\preformatted{
ContractionsPipe$new(propertyName = "contractions",
                     propertyLanguageName = "language",
                     alwaysBeforeDeps = list("GuessLanguagePipe"),
                     notAfterDeps = list(),
                     replaceContractions = TRUE,
                     resourcesContractionsPath = NULL)
}
\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) name of the property associated with the Pipe.
}
\item{\strong{propertyLanguageName:}}{
(\emph{character}) name of the language property.
}
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the dependences alwaysBefore (Pipes that must be executed before this
one).
}
\item{\strong{notAfterDeps:}}{
(\emph{list}) the dependences notAfter (Pipes that cannot be executed after this one).
}
\item{\strong{replaceContractions:}}{
(\emph{logical}) indicates if the contractions are replace or not.
}
\item{\strong{resourcesContractionsPath:}}{
(\emph{character}) path of resource files (in json format) containing the
correspondence between contractions and meaning.
}
}
}
}
}

\section{Details}{

\code{\link{ContractionPipe}} class requires the resource files (in json format)
containing the correspondence between contractions and meaning. To this end,
the language of the text indicated in the \emph{propertyLanguageName} should
be contained in the resource file name (ie. contr.xxx.json where xxx is the
value defined in the \emph{propertyLanguageName} ). The location of the
resources should be defined in the \strong{"resources.contractions.path"}
field of \emph{\link{bdpar.Options}} variable.
}

\section{Note}{

\code{\link{ContractionPipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{pipe:}}{
preprocesses the \code{\link{Instance}} to obtain/replace the contractions.
The contractions found in the Pipe are added to the list of properties of
the \code{\link{Instance}}.
\itemize{
\item{\emph{Usage:}}{
\code{pipe(instance)}
}
\item{\emph{Value:}}{
the \code{\link{Instance}} with the modifications that have occurred in the Pipe.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) \code{\link{Instance}} to preproccess.
}
}
}
}
}

\item{\bold{findContraction:}}{
checks if the contractions is in the data.
\itemize{
\item{\emph{Usage:}}{
\code{findContraction(data, contraction)}
}
\item{\emph{Value:}}{
boolean, depending on whether the contraction is on the data.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{data:}}{
(\emph{character}) text where contraction will be searched.
}
\item{\strong{contraction:}}{
(\emph{character}) indicates the contraction to find.
}
}
}
}
}

\item{\bold{replaceContraction:}}{
replaces the contraction in the data for the \emph{extendedContraction}.
\itemize{
\item{\emph{Usage:}}{
\code{replaceContraction(contraction, extendedContraction, data)}
}
\item{\emph{Value:}}{
the data with the contractions replaced.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{contraction:}}{
(\emph{character}) indicates the contraction to remove.
}
\item{\strong{extendedContraction:}}{
(\emph{character}) indicates the string to replace for the contraction found.
}
\item{\strong{data:}}{
(\emph{character}) text where contraction will be replaced.
}
}
}
}
}

\item{\bold{getPropertyLanguageName:.}}{
gets of name of property language.
\itemize{
\item{\emph{Usage:}}{
\code{getPropertyLanguageName()}
}
\item{\emph{Value:}}{
value of name of property language.
}
}
}

\item{\bold{getResourcesContractionsPath:}}{
gets of path of contractions resources.
\itemize{
\item{\emph{Usage:}}{
\code{getResourcesContractionsPath()}
}
\item{\emph{Value:}}{
value of path of contractions resources.
}
}
}

\item{\bold{setResourcesContractionsPath:}}{
sets the path of contractions resources.
\itemize{
\item{\emph{Usage:}}{
\code{setResourcesContractionsPath(path)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{path:}}{
(\emph{character}) the new value of the path of contractions resources.
}
}
}
}
}
}
}

\section{Private fields}{

\itemize{
\item{\bold{propertyLanguageName:}}{
 (\emph{character}) the name of property about language.
}
\item{\bold{resourcesContractionsPath:}}{
 (\emph{character}) path of resource files (in json format) containing the
correspondence between contractions and meaning.
}
\item{\bold{replaceContractions:}}{
 (\emph{logical}) indicates if the contractions are replace or not.
}
}
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{bdpar.Options}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindHashtagPipe}},
         \code{\link{FindUrlPipe}}, \code{\link{FindUserNamePipe}},
         \code{\link{GuessDatePipe}}, \code{\link{GuessLanguagePipe}},
         \code{\link{Instance}}, \code{\link{InterjectionPipe}},
         \code{\link{MeasureLengthPipe}}, \code{\link{GenericPipe}},
         \code{\link{ResourceHandler}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
