% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractorTwtid.R
\docType{class}
\name{ExtractorTwtid}
\alias{ExtractorTwtid}
\title{Class to handle tweets files with twtid extension}
\usage{
ExtractorTwtid
}
\description{
This class inherits from the \code{\link{Instance}} class and
implements the functions of extracting the text and the date of an twtid type file.
}
\section{Constructor}{

\code{ExtractorTwtid$new(path,
                         cachePath = NULL)}
\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{path:}}{
(\emph{character}) path of the twtid type file.
}
\item{\strong{cachePath:}}{
(\emph{character}) path of the cache location. If it is NULL, checks if is
defined in the \strong{"cache.twitter.path"} field of
\emph{\link{bdpar.Options}} variable.
}
}
}
}
}

\section{Details}{


Twitter connection is handled through the \code{\link{Connections}} class
which loads the Twitter API credentials from the \emph{{bdpar.Options}} object.
Additionally, to increase the processing speed, each twitter query is stored
in a cache to avoid the execution of duplicated queries. To enable this option,
cache location should be in the \strong{"cache.twitter.path"} field of
\emph{{bdpar.Options}} variable. This variable has to be the
path to store the tweets and it is neccesary that it has two folder named:
"_spam_" and "_ham_"
}

\section{Inherit}{

This class inherits from \code{\link{Instance}} and implements the
\code{obtainSource} and \code{obtainDate} abstracts functions.
}

\section{Methods}{

\itemize{
\item{\bold{obtainId:}}{
obtains the ID of an specific tweet. Reads the ID of the file indicated in
the variable path.
\itemize{
\item{\emph{Usage:}}{
\code{obtainId()}
}
}
}
\item{\bold{getId:}}{
gets the ID of an specific tweet.
\itemize{
\item{\emph{Usage:}}{
\code{getId()}
}
\item{\emph{Value:}}{
value of tweet ID.
}
}
}
\item{\bold{obtainDate:}}{
obtains the date from a specific tweet ID. If the tweet has been previously
cached the tweet date is loaded from cache path. Otherwise, the request is
performed using Twitter API and the date is automatically formatted to
"%a %b %d %H:%M:%S %Z %Y" (i.e. "Thu May 02 06:52:36 UTC 2013").
\itemize{
\item{\emph{Usage:}}{
\code{obtainDate()}
}
}
}
\item{\bold{obtainSource:}}{
obtains the source from a specific tweet ID. If the tweet has previously been
cached the source is loaded from cache path. Otherwise, the request is
performed using on Twitter API.
\itemize{
\item{\emph{Usage:}}{
\code{obtainSource()}
}
}
}
}
}

\section{Private fields}{

\itemize{
\item{\bold{id:}}{
 (\emph{character}) ID of tweet.
}
}
}

\seealso{
\code{\link{bdpar.Options}}, \code{\link{Connections}},
         \code{\link{ExtractorEml}}, \code{\link{ExtractorSms}},
         \code{\link{ExtractorYtbid}}, \code{\link{Instance}},
}
