% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tournament.R
\name{tournament}
\alias{tournament}
\title{Tournament - Model comparison}
\usage{
tournament(formula = NULL, data = NULL, ..., winning_criteria = 0.75)
}
\arguments{
\item{formula}{an object of class "formula", with discharge column name as response and stage column name as a covariate.}

\item{data}{data.frame containing the variables specified in formula.}

\item{...}{optional arguments passed to the model functions. Also, if data and formula are NULL, one can add four model objects of types "gplm", "gplm0", "plm" and "plm0". This runs the tournament for the input models and prevents running all four models explicitly.}

\item{winning_criteria}{a numerical value between 0 and 1 which sets the threshold for which the probability of the more complex model given the data in each model comparison, must exceed for it to be declared the better model. This value defaults to 0.75 to favor the less complex models when the superiority of the more complex model is somewhat ambiguous. See the Details section.}
}
\value{
An object of type "tournament" with the following elements
\describe{
 \item{\code{summary}}{a data frame with information on results of the different games in the tournament.}
 \item{\code{contestants}}{model objects of types "plm0","plm","gplm0" and "gplm" being compared.}
 \item{\code{winner}}{model object of the tournament winner.}
}
}
\description{
tournament compares four rating curve models of different complexities and determines the model that provides the best fit of the data at hand.
}
\details{
Tournament is a comparison method that uses Bayes factor to compute the posterior probabilities of the models and select the most appropriate of the four models given the data. The first round of model comparisons sets up model types "gplm" vs. "gplm0" and "plm" vs. "plm0". If the posterior probability of the more complex model ("gplm" and "plm", respectively) exceeds the "winning_criteria" (default value = 0.75) then it is chosen as the more appropriate model and moves on to the second and final round, where the winners from the first round will be compared in the same way. In the second round, if the more complex model (now the generalized power-law model) exceeds the same "winning_criteria" then it is chosen as the overall tournament winner and deemed the most appropriate model given the data. In each of the three matches, the posterior probabilities of the models are computed using the Bayes factor and assuming a priori that the two models were equally likely [see Jeffreys (1961) and Kass and Raftery (1995)].
}
\examples{
\donttest{
data(krokfors)
set.seed(1)
t_obj <- tournament(formula=Q~W,data=krokfors,num_cores=2)
t_obj
summary(t_obj)
}
}
\references{
B. Hrafnkelsson, H. Sigurdarson, S.M. Gardarsson, 2020, Generalization of the power-law rating curve using hydrodynamic theory and Bayesian hierarchical modeling. arXiv preprint 2010.04769.

Jeffreys, H. (1961). Theory of Probability, Third Edition. Oxford University Press.

Kass, R., and A. Raftery, A. (1995). Bayes Factors. Journal of the American Statistical Association, 90, 773-795.
}
\seealso{
\code{\link{summary.tournament}} and \code{\link{plot.tournament}}
}
