% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_beast2_input_file.R
\name{is_beast2_input_file}
\alias{is_beast2_input_file}
\title{Is a file a valid BEAST2 input file?}
\usage{
is_beast2_input_file(
  filename,
  show_warnings = FALSE,
  verbose = FALSE,
  beast2_path = get_default_beast2_path()
)
}
\arguments{
\item{filename}{name of the BEAST2 XML input file}

\item{show_warnings}{if TRUE, warnings will shown}

\item{verbose}{if TRUE, additional information is displayed, that
is potentially useful in debugging}

\item{beast2_path}{name of either a BEAST2 binary file
(usually simply \code{beast})
or a BEAST2 jar file
(usually has a \code{.jar} extension).
Use \link{get_default_beast2_bin_path} to get
the default BEAST binary file's path
Use \link{get_default_beast2_jar_path} to get
the default BEAST jar file's path}
}
\value{
TRUE if the file is valid, FALSE if not
}
\description{
Is a file a valid BEAST2 input file?
}
\note{
this function only works on standard BEAST2 input files:
    if a BEAST2 input file is modified to use a certain BEAST2 package,
    this function will label it as an invalid file
}
\examples{
check_empty_beaustier_folders()

if (is_beast2_installed() && is_on_ci()) {

  filename <- get_beastier_path("anthus_2_4.xml")
  # TRUE, this is a BEAST2 input file
  is_beast2_input_file(filename)

  filename <- get_beastier_path("beast2_example_output.log")
  # FALSE, this is not a BEAST2 input file,
  # it is a BEAST2 output log file insteaf
  is_beast2_input_file(filename)
}

check_empty_beaustier_folders()
}
\seealso{
Use \code{\link{are_beast2_input_lines}} to check the lines
}
\author{
Richèl J.C. Bilderbeek
}
