% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_param.R
\name{create_m_param}
\alias{create_m_param}
\alias{create_param_m}
\title{Create a parameter called m}
\usage{
create_m_param(id = NA, estimate = FALSE, value = 0)
}
\arguments{
\item{id}{the parameter's ID}

\item{estimate}{TRUE if this parameter alpha be estimated by BEAST2,
FALSE otherwise}

\item{value}{value of the parameter}
}
\value{
a parameter called m
}
\description{
Create a parameter called m
}
\note{
this parameter is used in a log-normal distribution
  (as returned by \code{\link{create_log_normal_distr}})
}
\examples{
  # Create the parameter
  m_param <- create_m_param()

  # Use the parameter in a distribution
  log_normal_distr <- create_log_normal_distr(
    m = m_param
  )

  # Use the distribution to create a BEAST2 input file
  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "create_m_param.xml",
    tree_priors = create_yule_tree_prior(
      birth_rate_distr = log_normal_distr
    )
  )
  testit::assert(file.exists("create_m_param.xml"))
}
\seealso{
the function \code{\link{create_param}} contains a list
  of all parameters that can be created
}
\author{
Richel J.C. Bilderbeek
}
