% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_log_normal_distr.R
\name{is_log_normal_distr}
\alias{is_log_normal_distr}
\title{Determine if the object is a valid
log-normal distribution,
as created by \code{\link{create_log_normal_distr}}}
\usage{
is_log_normal_distr(x)
}
\arguments{
\item{x}{an object, to be determined if it is a valid
log-normal distribution}
}
\value{
TRUE if x is a valid log-normal distribution,
  FALSE otherwise
}
\description{
Determine if the object is a valid
log-normal distribution,
as created by \code{\link{create_log_normal_distr}}
}
\examples{
  log_normal_distr <- create_log_normal_distr()

  input_fasta_filename <- beautier::get_beautier_path("anthus_aco.fas")
  create_beast2_input_file(
    input_filenames = input_fasta_filename,
    "my_beast.xml",
    tree_priors = create_yule_tree_prior(
      birth_rate_distr = log_normal_distr
    )
  )
  testit::assert(file.exists("my_beast.xml"))
}
\seealso{
use \code{\link{is_distr}} to see if x is any
  distribution
}
\author{
Richel J.C. Bilderbeek
}
