% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_clock_model.R
\name{is_strict_clock_model}
\alias{is_strict_clock_model}
\title{Determine if the object is a valid strict clock model,
  as returned by \code{\link{create_strict_clock_model}}}
\usage{
is_strict_clock_model(x)
}
\arguments{
\item{x}{an object, to be determined if it is a valid strict clock model}
}
\value{
TRUE if x is a valid strict clock model, FALSE otherwise
}
\description{
Determine if the object is a valid strict clock model,
  as returned by \code{\link{create_strict_clock_model}}
}
\examples{
library(testthat)

expect_true(is_strict_clock_model(create_strict_clock_model()))
expect_false(is_strict_clock_model(create_rln_clock_model()))

expect_false(is_strict_clock_model(NA))
expect_false(is_strict_clock_model(NULL))
expect_false(is_strict_clock_model("nonsense"))
expect_false(is_strict_clock_model(create_jc69_site_model()))
expect_false(is_strict_clock_model(create_mcmc()))
}
\seealso{
\code{\link{create_clock_model}} shows an overview of
  functions to create a clock model
}
\author{
Richèl J.C. Bilderbeek
}
