% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distr.R
\name{create_exp_distr}
\alias{create_exp_distr}
\alias{create_distr_exp}
\title{Create an exponential distribution}
\usage{
create_exp_distr(id = NA, mean = 1)
}
\arguments{
\item{id}{the distribution's ID}

\item{mean}{the mean parameter,
a numeric value.
For advanced usage, use the structure
as returned by \code{\link{create_mean_param}}}
}
\value{
an exponential distribution
}
\description{
Create an exponential distribution
}
\examples{
  exp_distr <- create_exp_distr()

  beast2_input_file <- tempfile(fileext = ".xml")
  create_beast2_input_file(
    input_filename = get_fasta_filename(),
    beast2_input_file,
    tree_prior = create_yule_tree_prior(
      birth_rate_distr = exp_distr
    )
  )
  testit::assert(file.exists(beast2_input_file))
}
\seealso{
the function \code{\link{create_distr}} shows an overview
  of all supported distributions
}
\author{
Richèl J.C. Bilderbeek
}
