% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_test_ns_mcmc.R
\name{create_test_ns_mcmc}
\alias{create_test_ns_mcmc}
\title{Create an NS MCMC object for testing}
\usage{
create_test_ns_mcmc(
  chain_length = 2000,
  store_every = 1000,
  pre_burnin = 0,
  n_init_attempts = 3,
  particle_count = 1,
  sub_chain_length = 500,
  epsilon = 1e-12,
  tracelog = create_test_tracelog(),
  screenlog = create_test_screenlog(),
  treelog = create_test_treelog()
)
}
\arguments{
\item{chain_length}{upper bound to the length of the MCMC chain}

\item{store_every}{number of states the MCMC will process
before the posterior's state will be saved to file.
Use -1 or \code{NA} to use the default frequency.}

\item{pre_burnin}{number of burn in samples taken before entering
the main loop}

\item{n_init_attempts}{number of initialization attempts before failing}

\item{particle_count}{number of particles}

\item{sub_chain_length}{sub-chain length}

\item{epsilon}{epsilon}

\item{tracelog}{a \code{tracelog},
as created by \link{create_tracelog}}

\item{screenlog}{a \code{screenlog},
as created by \link{create_screenlog}}

\item{treelog}{a \code{treelog},
as created by \link{create_treelog}}
}
\value{
an MCMC object
}
\description{
Create an NS MCMC object for testing
}
\examples{

mcmc <- create_test_ns_mcmc()

beast2_input_file <- tempfile(fileext = ".xml")

create_beast2_input_file(
  get_fasta_filename(),
  beast2_input_file,
  mcmc = mcmc
)
}
\seealso{
Use \code{\link{create_ns_mcmc}} to create a default
nested sampling MCMC
}
\author{
Richèl J.C. Bilderbeek
}
