% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distr.R
\name{create_one_div_x_distr}
\alias{create_one_div_x_distr}
\alias{create_distr_one_div_x}
\title{Create a 1/x distribution}
\usage{
create_one_div_x_distr(id = NA, value = NA, lower = NA, upper = NA)
}
\arguments{
\item{id}{the distribution's ID}

\item{value}{the initial value for the MCMC}

\item{lower}{the lower bound, the lowest possible value}

\item{upper}{an upper limit of the uniform distribution.
If the upper limits needs to be infinity, set \code{upper} to \code{Inf}.}
}
\value{
a 1/x distribution
}
\description{
Create a 1/x distribution
}
\examples{
if (is_on_ci()) {

  one_div_x_distr <- create_one_div_x_distr()

  beast2_input_file <- get_beautier_tempfilename()
  create_beast2_input_file(
    input_filename = get_fasta_filename(),
    beast2_input_file,
    tree_prior = create_yule_tree_prior(
      birth_rate_distr = one_div_x_distr
    )
  )
  file.remove(beast2_input_file)

  remove_beautier_folder()
}
}
\seealso{
the function \code{\link{create_distr}} shows an overview
  of all supported distributions
}
\author{
Richèl J.C. Bilderbeek
}
