% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnc.R
\name{nnc}
\alias{nnc}
\alias{nnt}
\alias{print.nnc}
\title{Numbers Needed for Change}
\usage{
nnc(
  d = NULL,
  cer = NULL,
  r = 1,
  n = NULL,
  threshold = NULL,
  mean = 0,
  sd = 1,
  poweredFor = NULL,
  thresholdSensitivity = NULL,
  eventDesirable = TRUE,
  eventIfHigher = TRUE,
  conf.level = 0.95,
  dReliability = 1,
  d.ci = NULL,
  cer.ci = NULL,
  r.ci = NULL,
  d.n = NULL,
  cer.n = NULL,
  r.n = NULL,
  plot = TRUE,
  returnPlot = TRUE,
  silent = FALSE
)

\method{print}{nnc}(x, digits = 2, ...)
}
\arguments{
\item{d}{The value of Cohen's \emph{d}.}

\item{cer}{The Control Event Rate.}

\item{r}{The correlation between the determinant and behavior (for mediated
Numbers Needed for Change).}

\item{n}{The sample size.}

\item{threshold}{If the event rate is not available, a threshold value can
be specified instead, which is then used in conjunction with the mean
(\code{mean}) and standard deviation (\code{sd}) and assuming a normal
distribution to compute the event rate.}

\item{mean}{The mean value, used to draw the plot, or, if no CER is provided
but instead the threshold value, to compute the CER.}

\item{sd}{The standard deviation, used to draw the plot (and to compute the
CER if a threshold value is supplied instead of the CER).}

\item{poweredFor}{The Cohen's \emph{d} value for which the study was
powered. This expected Cohen's \emph{d} value can be used to compute the
threshold, which then in turn is used to compute the CER. To use this
approach, also specify the mean and the standard deviation.}

\item{thresholdSensitivity}{This argument can be used to provide a vector of
potential threshold values, each of which is used to compute an NNC. This
enables easy inspection of whether the value chosen as threshold matters
much for the NNC.}

\item{eventDesirable}{Whether an event is desirable or undesirable.}

\item{eventIfHigher}{Whether scores above or below the threshold are
considered 'an event'.}

\item{conf.level}{The confidence level of the confidence interval.}

\item{dReliability}{If Cohen's d was not measured with perfect reliability,
\code{nnc} can disattenuate it to correct for the resulting attenuation using
\code{\link[ufs:disattenuate.d]{ufs::disattenuate.d()}} before computating the Experimental Event Rate. Use
this argument to specify the reliability of the outcome measure. By default,
the setting of 1 means that no disattenuation is applied.}

\item{d.ci}{Instead of providing a point estimate for Cohen's \emph{d}, a
confidence interval can be provided.}

\item{cer.ci}{Instead of providing a point estimate for the Control Event
Rate, a confidence interval can be provided.}

\item{r.ci}{Instead of providing a point estimate for the correlation, a
confidence interval can be provided.}

\item{d.n}{In addition to providing a point estimate for Cohen's \emph{d}, a
sample size can be provided; if it is, the confidence interval is computed.}

\item{cer.n}{In addition to providing a point estimate for the Control Event
Rate, a sample size can be provided; if it is, the confidence interval is
computed.}

\item{r.n}{In addition to providing a point estimate for the correlation, a
sample size can be provided; if it is, the confidence interval is computed.}

\item{plot}{Whether to generate and show the plot.}

\item{returnPlot}{Whether to return the plot (as an attribute), or to only
display it.}

\item{silent}{Whether to suppress notifications.}

\item{x}{The \code{nnc} object to print.}

\item{digits}{The number of digits to round to.}

\item{...}{Any additional arguments are passed to the \code{print} function.}
}
\value{
The Numbers Needed for Change (NNC), potentially with a plot
visualising the NNC in an attribute.
}
\description{
This function computes the Numbers Needed for Change, and shows a
visualisation to illustrate them. Numbers Needed for Change is
the name for a Numbers Needed to Treat estimate that was computed
for a continuous outcome as is common in behavior change research.
}
\details{
Numbers Needed to Treat is a common and very useful effect size
measure in use in the medical sciences. It is computed based on the
Control Event Rate (CER) and the Experimental Event Rate (EER), and
expresses how many people would need to received a treatment to yield
a beneficial result for one person. In behavior change research, a
similar measure would be useful, but the outcome is normally not
dichotomous as is common in the medical literature (i.e. whether a
participants survives or is cured), but continuous. Numbers Needed
for Change fills this lacuna: it is simply the Numbers Needed to Treat,
but converted from a Cohen's d value. \code{nnt} is an alias for \code{nnc}.

For more details, see Gruijters & Peters (2019) for details.
}
\examples{

### Simple example
behaviorchange::nnc(d=.4, cer=.3);

### Or for a scenario where events are undesirable, and the
### intervention effective (therefore having a negative value for d):
behaviorchange::nnc(d=-.4, cer=.3, eventDesirable=FALSE);

}
\references{
Gruijters, S. L., & Peters, G. Y. (2019). Gauging the
impact of behavior change interventions: A tutorial on the Numbers
Needed to Treat. \emph{PsyArXiv.} doi:\href{https://doi.org/10.31234/osf.io/2bau7}{10.31234/osf.io/2bau7}
}
\author{
Gjalt-Jorn Peters & Stefan Gruijters

Maintainer: Gjalt-Jorn Peters \href{mailto:gjalt-jorn@userfriendlyscience.com}{gjalt-jorn@userfriendlyscience.com}
}
\keyword{utilities}
