\name{bentcableAR}
\alias{bentcableAR}
\alias{bentcable}
\alias{bentcableAR-package}
\docType{package}
\title{ The Bent-Cable Regression Package }
\description{
	Perform bent-cable (including broken-stick) regression to independent
	data or autoregressive time series.
}
\details{
\tabular{ll}{
Package: \tab bentcableAR\cr
Type: \tab Package\cr
Version: \tab 0.2.3\cr
Date: \tab 2010-09-20\cr
License: \tab GPL (>=3)\cr
}
There are two main interfaces in this package:
\code{\link{bentcable.dev.plot}} for plotting profile deviance
surfaces, and \code{\link{bentcable.ar}} for fitting and diagnosing 
the regression. In some cases, confidence intervals for the
\emph{change point} are also computed..

Detailed documentation and examples are available on the function help
pages.

The major engines for \code{bentcable.dev.plot} are
\code{\link{cable.dev}} and \code{\link{cable.fit.known.change}}.
The computational engines for \code{bentcable.ar} are
\code{\link{cable.ar.p.iter}}, \code{\link{cable.ar.0.fit}},
\code{\link{stick.ar.0}}, and \code{\link{cable.change.conf}},
while the plotting engine is \code{\link{cable.ar.p.diag}}.
Although these and other \emph{lesser} functions are called
internally by the two main interfaces described above, they can be
used as stand-alone functions, and the user is advised to
refer to their documentation. Type
\code{library(help="bentcableAR")} for a full list of available
functions.

\bold{Disclaimer:}
The package functions and examples have been thoroughly tested in \R
2.6.2 installed on the author's two Mac machines running OS X. Results
are known to vary depending on machine and platform.
}
\author{
Grace Chiu <bentcable at gmail.com>

Maintainer: Grace Chiu <bentcable at gmail.com>
}
\references{
Chiu, G.S. and Lockhart, R.A. (2010), Bent-Cable Regression with
   Autoregressive Noise, \emph{Canadian Journal of Statistics},
   \bold{38}, 386--407.
	\url{http://faculty.washington.edu/gchiu/Articles/bentcable-cjs.pdf}

Chiu, G., Lockhart, R. and Routledge, R. (2006), Bent-Cable Regression
	Theory and Applications, \emph{Journal of the American Statistical
	Association}, \bold{101}, 542--553.
	\url{http://faculty.washington.edu/gchiu/Articles/bentcable-jasa.pdf}
}
\keyword{ package }
