% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{margalef}
\alias{margalef}
\alias{margalef_}
\title{Margalef Index of Diversity}
\usage{
margalef(.data = NULL, taxon, count)

margalef_(.data = NULL, taxon, count)
}
\arguments{
\item{.data}{data in a \code{data.frame}, \code{tibble}, 
\code{data.table}, database etc.}

\item{taxon}{taxa names (\code{character})}

\item{count}{counts (\code{numeric})}
}
\value{
Margalef diversity index (\code{numeric} \code{vector} of length 1)
}
\description{
Margalef Index of Diversity is given by
\deqn{D = \frac{S-1}{\ln(N)}}{D = (S-1)/ln(N)}
 
For \eqn{N=1}, the index is set to 0.
}
\section{Functions}{
\itemize{
\item \code{margalef_()}: version suitable for calling from a function
(see package \pkg{lazyeval}).

}}
\examples{
margalef(
    taxon = c("Euspira pulchella", "Nephtys cirrosa"), 
    count = c(4, 6)
)
 
}
