% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse.R
\name{nse}
\alias{nse}
\title{Nash-Sutcliffe efficiency}
\usage{
nse(obs, sim)
}
\arguments{
\item{obs}{Vector with observational data.}

\item{sim}{simulated data.}
}
\value{
Numeric.
}
\description{
Compute Nash-Sutcliffe efficiency from two vectors. Based on eval.NSeff in RHydro Package
}
\details{
Basically does the following, after some input checks: 1 - ( sum((obs - sim)^2) / sum((obs - mean(obs))^2) )
}
\note{
NAs are omitted with warning.
}
\examples{

SIM <- dbeta(1:40/40, 3, 10)
OBS <- SIM + rnorm(20,,0.2)
plot(OBS)
lines(SIM)
nse(OBS, SIM)

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, July 2013
}
\seealso{
\code{\link{rmse}}, \code{\link{rsquare}}
}
\keyword{ts}

