% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdfpng.R
\name{pdfpng}
\alias{pdfpng}
\title{Create pdf and png graph}
\usage{
pdfpng(expr, file, pdf = TRUE, png = TRUE, overwrite = FALSE,
  open = TRUE, quiet = FALSE, tracewarnmes = !quiet, filargs = NULL,
  width = 7, height = 5, units = "in", res = 500, seed = runif(1,
  -1e+09, 1e+09), envlevel = 1, pdfargs = NULL, pngargs = NULL, ...)
}
\arguments{
\item{expr}{Expression creating the plot, can be included in curly braces.}

\item{file}{Character: Filename without pdf/png extension.
Unless overwrite=TRUE, files will not be overwritten, but
"_1" will be appended instead, see \code{\link{newFilename}}.
If \code{expr} creates several plots, use file="fname\%02d",
otherwise the png will only contain the last figure.
Note: this overwrites files as the \% notation is not
captured by newFilename. You may also have to run dev.off().}

\item{pdf}{Logical: Create pdf? DEFAULT: TRUE}

\item{png}{Logical: Create png? DEFAULT: TRUE}

\item{overwrite}{Logical: Overwrite existing \code{file}? Can be a vector
for pdf and png separately.
DEFAULT: FALSE (_n appended in filename)}

\item{open}{Logical: open file(s) after creation using \code{\link{openFile}}? 
DEFAULT: TRUE}

\item{quiet}{Logical: suppress file creation messages and
expr execution error tracing? DEFAULT: FALSE}

\item{tracewarnmes}{Logical: trace warnings and messages in expr execution?
Errors are always traced. Default: !quiet}

\item{filargs}{List of other arguments passed to \code{\link{newFilename}}.
DEFAULT: NULL}

\item{width, height}{Graph dimensions. DEFAULT: 7x5 inches}

\item{units, res}{Graph quality arguments passed only to \code{\link{png}}.
DEFAULT: inches ("in"), 500 ppi}

\item{seed}{Seed passed to \code{\link{set.seed}} before each call.
DEFAULT: runif(1,-1e9,1e9)}

\item{envlevel}{Environment level passed to \code{\link{eval.parent}}.
Never needs to be changed, as far as I can tell. DEFAULT: 1}

\item{pdfargs}{List of arguments only passed to \code{\link{pdf}}.}

\item{pngargs}{List of arguments only passed to \code{\link{png}}.}

\item{\dots}{Further arguments passed to both \code{\link{pdf}} and \code{\link{png}}}
}
\value{
Nothing
}
\description{
Create both a \code{\link{pdf}} and a \code{\link{png}} file with a graph,
with custom size default values.
To iteratively create pdfs without closing and reopening the pdf viewer, you
might want to use e.g. Sumatra, which comes with Rstudio. It can be found e.g. in
C:/Program Files/RStudio/bin/sumatra
}
\examples{

\dontrun{ # excluded from CRAN checks, file opening not wanted
pdfpng(   plot(rnorm(500), type="l")   , file="dummyplot", png=FALSE)
}

pdfpng({par(bg=8, las=1); plot(cumsum(rnorm(500)), type="l")},
       file="dummyplot", res=100, open=FALSE)
pdfpng({par(bg=8, las=1); plot(cumsum(rnorm(500)), type="l")},
       file="dummyplot", overwrite=c(TRUE,FALSE), open=FALSE)

# Nesting of functions is possible:
a <- list( cumsum(rnorm(2000)), cumsum(rnorm(20)) )
pdfpng(plot(a[[1]]), file="dummyplot", overwrite=TRUE, open=FALSE)
bfun <- function(b) pdfpng(plot(b,type="l"), file="dummyplot", 
                           overwrite=TRUE, open=FALSE)
cfun <- function(c) bfun(c)
bfun(a[[1]])
sapply(a, function(d) cfun(d))


pdfpng(plot(-10:100, log="y"), "dummyplot",overwr=TRUE,png=FALSE, open=FALSE)
pdfpng({plot(1); plot(dummyobject)}, "dummyplot", overwrite=TRUE, 
       png=FALSE, open=FALSE)


unlink("dummyplot.pdf") ; unlink("dummyplot.png") ; unlink("dummyplot_1.png")

}
\seealso{
\code{\link{pdf}}, \code{\link{png}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, March 2017
}
\keyword{file}
