% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertUmlaut.R
\name{convertUmlaut}
\alias{convertUmlaut}
\title{Convert German Umlaute to ASCII}
\usage{
convertUmlaut(x)
}
\arguments{
\item{x}{Character string(s) containing German Umlaute}
}
\value{
Character strings
}
\description{
Convert German Umlaute (ae, oe, ue, ss) to ASCII.
Conversion happens case sensitive for the first three.
}
\examples{
\dontrun{
link <- paste0("ftp://ftp-cdc.dwd.de/pub/CDC/observations_germany/climate/",
               "monthly/kl/recent/KL_Monatswerte_Beschreibung_Stationen.txt")
weatherstations <- read.fwf(link, widths=c(6,9,10,16,11,8,41,99), skip=3)
examples <- trimws(weatherstations[c(153, 509, 587, 2, 651, 851),7])
examples
convertUmlaut(examples) # note how lower and upper case is kept
}

}
\seealso{
\code{tools::\link[tools]{showNonASCII}}, \code{\link{gsub}},
        \code{\link{iconv}(x, to="ASCII//TRANSLIT")}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Oct-Nov 2016
}
\keyword{character}
