% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaMethod-methods.R
\name{summary.deltamethod}
\alias{summary.deltamethod}
\title{Summary Method for an Object of Class \code{deltamethod}}
\usage{
\method{summary}{deltamethod}(object, alpha = NULL, digits = 4, ...)
}
\arguments{
\item{object}{Object of class \code{deltamethod}.}

\item{alpha}{Numeric vector.
Significance level \eqn{\alpha}.
If \code{alpha = NULL},
use the argument \code{alpha} used in \code{object}.}

\item{digits}{Digits to print.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of
standardized regression slopes,
standard errors,
test statistics,
degrees of freedom,
p-values,
and
confidence intervals.
}
\description{
Summary Method for an Object of Class \code{deltamethod}
}
\examples{
object <- glm(
  formula = vs ~ wt + disp,
  family = "binomial",
  data = mtcars
)
def <- list("exp(wt)", "exp(disp)")
out <- DeltaGeneric(
  object = object,
  def = def,
  alpha = 0.05
)
summary(out)

}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
