% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaSandwich-methods-r-sq-beta-sandwich.R
\name{summary.rsqbetasandwich}
\alias{summary.rsqbetasandwich}
\title{Summary Method for an Object of Class \code{rsqbetasandwich}}
\usage{
\method{summary}{rsqbetasandwich}(object, alpha = NULL, digits = 4, ...)
}
\arguments{
\item{object}{Object of class \code{rsqbetasandwich}.}

\item{alpha}{Numeric vector.
Significance level \eqn{\alpha}.
If \code{alpha = NULL},
use the argument \code{alpha} used in \code{object}.}

\item{digits}{Digits to print.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of
multiple correlation coefficients
(R-squared and adjusted R-squared),
standard errors,
test statistics,
degrees of freedom,
p-values,
and
confidence intervals.
}
\description{
Summary Method for an Object of Class \code{rsqbetasandwich}
}
\examples{
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
std <- BetaHC(object)
rsq <- RSqBetaSandwich(std)
summary(rsq)

}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
