% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{afac}
\alias{afac}
\title{Ascending (rising) factorial.}
\usage{
afac(x, r)
}
\arguments{
\item{x}{A value for which the ascending factorial is to be calculated.}

\item{r}{The power \code{x} is to be raised to.}
}
\value{
The ascending factorial of value \code{x} raised to the \code{r} power.
}
\description{
Calculate the ascending (or rising) factorial of a value \code{x} of order \code{r}.
}
\note{
This function implements the ascending factorial by means of the Gamma distribution. As such, \code{x} does not have to be an integer. However, \code{x} cannot be a negative integer.
}
\examples{
# To calculate the 4th ascending factorial for a value (e.g., 3.14):
afac(x = 3.14, r = 4)

# To calculate the 5th ascending factorial for values 3.14, 2.72, and 0.58:
afac(x = c(3.14, 2.72, 0.58), r = 5)
}
