% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{MLB}
\alias{MLB}
\title{Most Likely True Beta Value Given Observed Outcome.}
\usage{
MLB(alpha, beta, x = NULL, n = NULL)
}
\arguments{
\item{alpha}{Observed alpha-parameter value for fitted Standard Beta PDD.}

\item{beta}{Observed beta-parameter value for fitted Standard Beta PDD.}

\item{x}{Observed proportion-correct outcome.}

\item{n}{Test-length.}
}
\value{
The Beta shape-parameter value for the Standard Beta probability density distribution where the observed mean is the expected mode.
}
\description{
Assuming a prior standard (two-parameter) Beta Distribution, return the beta shape-parameter value where the observed mean becomes the mode.
}
\examples{
# Assuming a prior Standard (two-parameter) Beta distribution is fit, which
# yield an alpha parameter of 10 and a beta parameter of 8, calculate the
# true-beta parameter most likely to have produced the observations:
MLB(a = 10, b = 8)
}
