% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_betaselect_methods.R
\name{predict.lm_betaselect}
\alias{predict.lm_betaselect}
\title{Predict Method for an 'lm_betaselect' Object}
\usage{
\method{predict}{lm_betaselect}(
  object,
  model_type = c("beta", "standardized", "raw", "unstandardized"),
  newdata,
  ...
)
}
\arguments{
\item{object}{An \code{lm_betaselect}-class
object.}

\item{model_type}{The model from which the
the predicted values are computed.
For
\code{"beta"} or \code{"standardized"}, the
model is the one after selected
variables standardized. For \code{"raw"}
or \code{"unstandardized"}, the model is
the one before standardization was
done.}

\item{newdata}{If set to a data
frame, the predicted values are
computed using this data frame.
The data must be unstandardized.
That is, the variables are of the
same units as in the data frame
used in \code{\link[=lm_betaselect]{lm_betaselect()}}. If
\code{model_type} is \code{"beta"} or
\code{"standardized"}, it will be
standardized using the setting
of \code{to_standardize} when \code{object}
is created in \code{\link[=lm_betaselect]{lm_betaselect()}}.}

\item{...}{Arguments
to be passed to \code{\link[stats:predict.lm]{stats::predict.lm()}}.
Please refer to the help page of
\code{\link[stats:predict.lm]{stats::predict.lm()}}.}
}
\value{
It returns the output of \code{\link[stats:predict.lm]{stats::predict.lm()}}.
}
\description{
Compute the predicted
values in a model fitted by
\code{lm_betaselect()}.
}
\details{
It simply passes the model \emph{before}
or \emph{after} selected variables
are standardized to the
\code{predict}-method of an \code{lm} object.
\subsection{IMPORTANT}{

Some statistics, such as prediction
or confidence interval, which make use
of the sampling variances and
covariances of coefficient estimates
\emph{may} not be applicable to the
models with one or more variables
standardized. Therefore, they should
only be used for exploratory purpose.
}
}
\examples{

data(data_test_mod_cat)

lm_beta_x <- lm_betaselect(dv ~ iv*mod + cov1 + cat1,
                           data = data_test_mod_cat,
                           to_standardize = "iv")
predict(lm_beta_x)
predict(lm_beta_x, model_type = "raw")

}
\seealso{
\code{\link[=lm_betaselect]{lm_betaselect()}} and \code{\link[stats:predict.lm]{stats::predict.lm()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
