% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_betaselect.R
\name{std_data}
\alias{std_data}
\title{Standardize Selected Variables}
\usage{
std_data(data, to_standardize)
}
\arguments{
\item{data}{A data frame or similar
object.}

\item{to_standardize}{A character
vector of the column names of
variables to be standardized.}
}
\value{
A data frame similar to \code{data},
with selected variables standardized.
}
\description{
Standardize selected
variables in a data frame or similar
object.
}
\details{
This is a helper functions
to be used by \code{\link[=lm_betaselect]{lm_betaselect()}}
and \code{\link[=glm_betaselect]{glm_betaselect()}}. It
assumes that the variables selected
has been checked whether they are
numeric.
}
\examples{

data(data_test_mod_cat)
dat <- data_test_mod_cat
dat <- std_data(dat, to_standardize = c("iv", "dv"))
colMeans(dat[, c("dv", "iv")])
apply(dat[, c("dv", "iv")], 2, sd)

}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
