% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maximum_pseudoposterior.R
\name{mppe}
\alias{mppe}
\title{Optimize Pseudoposterior for an Ordinal Markov Random Field Model}
\usage{
mppe(
  x,
  interaction_prior = c("Cauchy", "UnitInfo"),
  cauchy_scale = 2.5,
  threshold_alpha = 0.5,
  threshold_beta = 0.5,
  convergence_criterion = sqrt(.Machine$double.eps),
  maximum_iterations = 1000,
  thresholds,
  interactions
)
}
\arguments{
\item{x}{A dataframe or matrix with \code{n} rows and \code{p} columns,
containing binary and ordinal variables for \code{n} independent observations
and \code{p} variables in the network. Variables are recoded as non-negative
integers \code{(0, 1, ..., m)} if not done already. Unobserved categories are
collapsed into other categories after recoding. See \code{reformat_data} for
details.}

\item{interaction_prior}{The prior distribution for the interaction effects.
Currently, two prior densities are implemented: The Unit Information prior
(\code{interaction_prior = "UnitInfo"}) and the Cauchy prior
(\code{interaction_prior = "Cauchy"}). Defaults to \code{"Cauchy"}.}

\item{cauchy_scale}{The scale of the Cauchy prior for interactions. Defaults
to \code{2.5}.}

\item{threshold_alpha, threshold_beta}{The shape parameters of the Beta-prime
prior for the thresholds. Default to \code{0.5}.}

\item{convergence_criterion}{The convergence criterion for the
pseudoposterior values in the EM algorithm. Defaults to
\code{sqrt(.Machine$double.eps)}.}

\item{maximum_iterations}{The maximum number of EM iterations used. Defaults
to \code{1e3}. A warning is issued if the procedure has not converged in
\code{maximum_iterations} iterations.}

\item{thresholds}{A matrix with \code{p} rows and \code{max(m)} columns,
containing the category thresholds for each node. Used as starting values in
the Newton-Raphson procedure. Optional.}

\item{interactions}{A matrix with \code{p} rows and \code{p} columns,
containing the pairwise association estimates in the off-diagonal elements.
Used as starting values in the Newton-Raphson procedure. Optional.}
}
\value{
A list containing:
\itemize{
\item \code{interactions}: A matrix with \code{p} rows and \code{p} columns,
containing the maximum pseudoposterior estimates of the pairwise
associations in the off-diagonal elements.
\item \code{thresholds}: A matrix with \code{p} rows and \code{max(m)}
columns, containing the maximum pseudoposterior estimates of the category
thresholds for each node.
\item \code{hessian}: A square matrix with \code{sum(m) + p(p-1)/2} rows and
columns, evaluated at the maximum pseudoposterior estimates. The top-left
square contains the thresholds, the bottom-right square the associations (of
the form \code{(1,2), (1, 3), ..., (2, 1), ...}).
}
In the case that \code{interaction_prior = "UnitInfo"}, the list also
contains the \code{p} by \code{p} matrix \code{unit_info}, which contains the
asymptotic variances that are used to set the unit information prior for the
association effects in the \code{bgms} function.
}
\description{
The function \code{mppe} estimates the parameters for the ordinal MRF
by optimizing the pseudoposterior with the Newton-Raphson method.
}
