% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgmcompare-methods.r
\name{coef.bgmCompare}
\alias{coef.bgmCompare}
\title{Extract Coefficients from a bgmCompare Object}
\usage{
\method{coef}{bgmCompare}(object, ...)
}
\arguments{
\item{object}{An object of class \code{bgmCompare}.}

\item{...}{Ignored.}
}
\value{
A list with components:
\describe{
  \item{main_effects_raw}{Posterior means of the raw main-effect parameters
  (variables x [baseline + differences]).}
  \item{pairwise_effects_raw}{Posterior means of the raw pairwise-effect parameters
  (pairs x [baseline + differences]).}
  \item{main_effects_groups}{Posterior means of group-specific main effects
  (variables x groups), computed as baseline plus projected differences.}
  \item{pairwise_effects_groups}{Posterior means of group-specific pairwise effects
  (pairs x groups), computed as baseline plus projected differences.}
  \item{indicators}{Posterior mean inclusion probabilities as a symmetric matrix,
  with diagonals corresponding to main effects and off-diagonals to pairwise effects.}
}
}
\description{
Returns posterior means for raw parameters (baseline + differences)
and group-specific effects from a \code{bgmCompare} fit, as well as inclusion indicators.
}
