% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PriorFunctions.R
\name{combinePriorParameters}
\alias{combinePriorParameters}
\title{combinePriorParameters}
\usage{
combinePriorParameters(list_of_prior_parameters)
}
\arguments{
\item{list_of_prior_parameters}{A list of items with class \code{prior_parameters_list}}
}
\value{
A list with prior parameters of class \code{prior_parameters_list}
}
\description{
This function combines prior parameters from different sources and returns them
for use in \code{\link[bhmbasket]{performAnalyses}}.
}
\details{
This function is intended to combine the prior parameters set with the functions
\code{\link[bhmbasket]{setPriorParametersBerry}},
\code{\link[bhmbasket]{setPriorParametersExNex}},
\code{\link[bhmbasket]{setPriorParametersExNexAdj}},
\code{\link[bhmbasket]{setPriorParametersPooled}}, or
\code{\link[bhmbasket]{setPriorParametersStratified}},
in case more than one analysis method should be applied with
\code{\link[bhmbasket]{performAnalyses}}.
}
\examples{
 prior_parameters_stratified <- setPriorParametersStratified(c(1, 2), c(3, 4))
 prior_parameters_berry      <- setPriorParametersBerry(0, 1, 2)

 prior_parameters_list       <- combinePriorParameters(
   list(prior_parameters_berry,
        prior_parameters_stratified))
}
\seealso{
\code{\link[bhmbasket]{performAnalyses}}
\code{\link[bhmbasket]{setPriorParametersBerry}}
\code{\link[bhmbasket]{setPriorParametersExNex}}
\code{\link[bhmbasket]{setPriorParametersExNexAdj}}
\code{\link[bhmbasket]{setPriorParametersPooled}}
\code{\link[bhmbasket]{setPriorParametersStratified}}
\code{\link[bhmbasket]{getPriorParameters}}
\code{\link[bhmbasket]{getMuVar}}
}
\author{
Stephan Wojciekowski
}
