% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PriorFunctions.R
\name{setPriorParametersStratified}
\alias{setPriorParametersStratified}
\title{setPriorParametersStratified}
\usage{
setPriorParametersStratified(a_j, b_j)
}
\arguments{
\item{a_j}{A vector of positive numerics for \eqn{\alpha}}

\item{b_j}{A vector of positive numerics for \eqn{\beta}}
}
\value{
A list with prior parameters of class \code{prior_parameters_list}
}
\description{
This function sets prior parameters for the analysis method \code{"stratified"}
for use in \code{\link[bhmbasket]{performAnalyses}}.
}
\details{
The method \code{"stratified"} is a beta-binomial model that assesses each cohort individually.
The prior parameters are the scale parameters of the beta prior distributions.
}
\examples{
 prior_parameters_pooled <- setPriorParametersStratified(c(1, 2), c(3, 4))
}
\seealso{
\code{\link[bhmbasket]{performAnalyses}}
\code{\link[bhmbasket]{getPriorParameters}}
\code{\link[bhmbasket]{combinePriorParameters}}
\code{\link[bhmbasket]{setPriorParametersBerry}}
\code{\link[bhmbasket]{setPriorParametersExNex}}
\code{\link[bhmbasket]{setPriorParametersExNexAdj}}
\code{\link[bhmbasket]{setPriorParametersPooled}}
\code{\link[bhmbasket]{getMuVar}}
}
\author{
Stephan Wojciekowski
}
