% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bib2df_gather.R
\name{bib2df_gather}
\alias{bib2df_gather}
\title{Parse a .bib file.}
\usage{
bib2df_gather(bib)
}
\arguments{
\item{bib, }{a character vector resulting from \code{bib2df_read()}.}
}
\value{
A \code{data.frame}.
}
\description{
\code{bib2df_gather} parses a .bib file and returns each BibTeX-item as a row in a \code{data.frame}.
}
\details{
\code{bib2df_gather} extracts the BibTeX entry types, fields and the respective values. Each item is presented as a row in a data_frame whereas the entry type (column \code{CATEGORY}) is added to each row.
}
\examples{
path <- system.file("extdata", "biblio.bib", package = "bib2df")
bib <- bib2df_read(path)
bib <- bib2df_gather(bib)
}
\author{
Philipp Ottolinger
}
