% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_suggest.R
\name{structure_suggestions}
\alias{structure_suggestions}
\title{Generate ranked, concept-grouped, actionable UI/UX suggestions}
\usage{
structure_suggestions(previous_stage, chosen_layout, concepts = NULL)
}
\arguments{
\item{previous_stage}{A tibble or list output from an earlier BID stage}

\item{chosen_layout}{Character string with the selected layout type}

\item{concepts}{Optional character vector of additional concepts to include}
}
\value{
List of concept groups with ranked suggestions
}
\description{
Creates structured suggestions organized by UX concepts with specific
component recommendations and rationales. Suggestions are ranked by
relevance and grouped by concept for systematic implementation.
}
\details{
The function combines concepts from multiple sources:
\itemize{
\item Stage 1 theory (from Notice)
\item Stage 2 inferred concepts (from keywords in story)
\item Optional user-provided concepts
}

Each suggestion includes:
\itemize{
\item title: Brief actionable description
\item details: Specific implementation guidance
\item components: Shiny/bslib component recommendations
\item rationale: 1-2 sentence explanation
\item score: Relevance ranking (0-1)
}
}
\keyword{internal}
