% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfa.perc.ci.R
\name{bfa.perc.ci}
\alias{bfa.perc.ci}
\title{Percentile Bootstrap Confidence Interval Function}
\usage{
bfa.perc.ci(a1.ls.star, conf.level = 0.95)
}
\arguments{
\item{a1.ls.star}{A numeric vector representing B replicates of the least squares estimator.}

\item{conf.level}{A numeric value representing the confidence level. Defaults to 0.95.}
}
\value{
A numeric vector representing the lower and upper limits of the confidence interval.
}
\description{
This function calculates the percentile  bootstrap CI for the least squares estimator of the
bifurcating autoregressive model.
}
\examples{
a1.ls.star <- c(rnorm(100,0.7,0.05))
bfa.perc.ci(a1.ls.star, conf.level= 0.95)
}
