% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_between_param.R
\name{estimate_between_param}
\alias{estimate_between_param}
\title{Estimate between-block parameters by logit}
\usage{
estimate_between_param(formula, network, block)
}
\arguments{
\item{formula}{formula for estimating between-block parameters}

\item{network}{network object}

\item{block}{a vector that represents which node belongs to which node}
}
\value{
'ergm' object of the estimated model.
}
\description{
Estimate between-block parameters by logit
}
\examples{
adj <- c(
c(0, 1, 0, 0, 1, 0),
c(1, 0, 1, 0, 0, 1),
c(0, 1, 0, 1, 1, 0),
c(0, 0, 1, 0, 1, 1),
c(1, 0, 1, 1, 0, 1),
c(0, 1, 0, 1, 1, 0)
)
adj <- matrix(data = adj, nrow = 6, ncol = 6)
rownames(adj) <- as.character(1001:1006)
colnames(adj) <- as.character(1001:1006)

# Use non-consecutive block names
block <- c(50, 70, 95, 50, 95, 70)

g <- network::network(adj, matrix.type = "adjacency")

est <- estimate_between_param(
  formula = g ~ edges,network = g, block = block
)
}
