% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_list_sparse_feature_adjmat.R
\name{get_list_sparse_feature_adjmat}
\alias{get_list_sparse_feature_adjmat}
\title{Get a list of sparse feature adjacency matrix from a formula}
\usage{
get_list_sparse_feature_adjmat(network, formula)
}
\arguments{
\item{network}{a network object from which nodal covariates are extracted.}

\item{formula}{a network model to be considered}
}
\value{
The list of sparse matrices of feature matrices that are used for the first step of the estimation.
}
\description{
Get a list of sparse feature adjacency matrix from a formula
}
\examples{
data(toyNet)
model_formula <- toyNet ~ edges + nodematch("x") + nodematch("y") 
list_feature_matrices <- 
  get_list_sparse_feature_adjmat(toyNet, model_formula)
}
