% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteorological_variables.r
\name{psychrometric.constant}
\alias{psychrometric.constant}
\title{Psychrometric Constant}
\usage{
psychrometric.constant(Tair, pressure, constants = bigleaf.constants())
}
\arguments{
\item{Tair}{Air temperature (deg C)}

\item{pressure}{Atmospheric pressure (kPa)}

\item{constants}{cp - specific heat of air for constant pressure (J K-1 kg-1) \cr
eps - ratio of the molecular weight of water vapor to dry air (-)}
}
\value{
\item{\eqn{\gamma} -}{the psychrometric constant (kPa K-1)}
}
\description{
Calculates the psychrometric 'constant'.
}
\details{
The psychrometric constant (\eqn{\gamma}) is given as:

   \deqn{\gamma = cp * pressure / (eps * \lambda)},
 
 where \eqn{\lambda} is the latent heat of vaporization (J kg-1), 
 as calculated with \code{\link{latent.heat.vaporization}}.
}
\examples{
psychrometric.constant(seq(5,45,5),100)

}
\references{
Monteith J.L., Unsworth M.H., 2008: Principles of Environmental Physics.
            3rd Edition. Academic Press, London.
}
