% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surface_conditions.r
\name{surface.conditions}
\alias{surface.conditions}
\title{Big-Leaf Surface Conditions}
\usage{
surface.conditions(data, Tair = "Tair", pressure = "pressure", LE = "LE",
  H = "H", VPD = "VPD", Ga = "Ga_h", calc.surface.CO2 = FALSE,
  Ca = "Ca", Ga_CO2 = "Ga_CO2", NEE = "NEE",
  Esat.formula = c("Sonntag_1990", "Alduchov_1996", "Allen_1998"),
  constants = bigleaf.constants())
}
\arguments{
\item{data}{Data.frame or matrix containing all required input variables}

\item{Tair}{Air temperature (deg C)}

\item{pressure}{Atmospheric pressure (kPa)}

\item{LE}{Latent heat flux (W m-2)}

\item{H}{Sensible heat flux (W m-2)}

\item{VPD}{Vapor pressure deficit (kPa)}

\item{Ga}{Aerodynamic conductance for heat/water vapor (m s-1)}

\item{calc.surface.CO2}{Calculate surface CO2 concentration? Defaults to \code{FALSE}.}

\item{Ca}{Atmospheric CO2 concentration (mol mol-1). Required if \code{calc.surface.CO2 = TRUE}.}

\item{Ga_CO2}{Aerodynamic conductance for CO2 (m s-1). Required if \code{calc.surface.CO2 = TRUE}.}

\item{NEE}{Net ecosystem exchange (umol m-2 s-1). Required if \code{calc.surface.CO2 = TRUE}.}

\item{Esat.formula}{Optional: formula to be used for the calculation of esat and the slope of esat.
One of \code{"Sonntag_1990"} (Default), \code{"Alduchov_1996"}, or \code{"Allen_1998"}.
See \code{\link{Esat.slope}}.}

\item{constants}{cp - specific heat of air for constant pressure (J K-1 kg-1) \cr 
eps - ratio of the molecular weight of water vapor to dry air (-) \cr
Pa2kPa - conversion pascal (Pa) to kilopascal (kPa)}
}
\value{
a data.frame with the following columns:
        \item{Tsurf}{Surface temperature (deg C)} \cr
        \item{esat_surf}{Saturation vapor pressure at the surface (kPa)} \cr
        \item{esurf}{vapor pressure at the surface (kPa)} \cr
        \item{VPD_surf}{vapor pressure deficit at the surface (kPa)} \cr
        \item{qsurf}{specific humidity at the surface (kg kg-1)} \cr
        \item{rH_surf}{relative humidity at the surface (-)} \cr
        \item{Ca_surf}{CO2 concentration at the surface (umol mol-1)}
}
\description{
Calculates meteorological conditions at the big-leaf surface
             by inverting bulk transfer equations for water, energy, and carbon
             fluxes.
}
\details{
Canopy surface temperature and humidity are calculated by inverting bulk transfer equations of
         sensible and latent heat, respectively. 'Canopy surface' in this case refers to 
         the surface of the big-leaf (i.e. at height d + z0h; the apparent sink of sensible heat and water vapor).
         Aerodynamic canopy surface temperature is given by:
         
           \deqn{Tsurf = Tair + H / (\rho * cp * Ga)}
         
         where \eqn{\rho} is air density (kg m-3). 
         Vapor pressure at the canopy surface is:
         
           \deqn{esurf = e + (LE * \gamma)/(Ga * \rho * cp)}
         
         where \eqn{\gamma} is the psychrometric constant (kPa K-1).
         Vapor pressure deficit (VPD) at the canopy surface is calculated as:
         
           \deqn{VPD_surf = Esat_surf - esurf}
           
         CO2 concentration at the canopy surface is given by:
         
           \deqn{Ca_surf = Ca + NEE / Ga_CO2}
         
         Note that Ga is assumed to be equal for water vapor and sensible heat.
         Ga is further assumed to be the inverse of the sum of the turbulent part
         and the canopy boundary layer conductance (1/Ga = 1/Ga_m + 1/Gb; 
         see \code{\link{aerodynamic.conductance}}). Ga_CO2, the aerodynamic conductance
         for CO2 is also calculated by \code{\link{aerodynamic.conductance}}.
         If Ga is replaced by Ga_m (i.e. only the turbulent conductance part), 
         the results of the functions represent conditions outside the canopy
         boundary layer, i.e. in the canopy airspace.
}
\note{
The following sign convention for NEE is employed (relevant if 
      \code{calc.surface.CO2 = TRUE}): 
      negative values of NEE denote net CO2 uptake by the ecosystem.
}
\examples{
# calculate surface temperature, water vapor, VPD etc. at the surface
# for a given temperature and turbulent fluxes, and under different 
# aerodynamic conductance.
surface.conditions(Tair=25,pressure=100,LE=100,H=200,VPD=1.2,Ga=c(0.02,0.05,0.1)) 
         
# now calculate also surface CO2 concentration
surface.conditions(Tair=25,pressure=100,LE=100,H=200,VPD=1.2,Ga=c(0.02,0.05,0.1),
                   Ca=400,Ga_CO2=c(0.02,0.05,0.1),NEE=-20,calc.surface.CO2=TRUE)
                   
}
\references{
Knauer, J. et al., 2018: Towards physiologically meaningful water-use efficiency estimates
            from eddy covariance data. Global Change Biology 24, 694-710.
            
            Blanken, P.D. & Black, T.A., 2004: The canopy conductance of a boreal aspen forest,
            Prince Albert National Park, Canada. Hydrological Processes 18, 1561-1578.
            
            Shuttleworth, W. J., Wallace, J.S., 1985: Evaporation from sparse crops-
            an energy combination theory. Quart. J. R. Met. Soc. 111, 839-855.
}
