% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigpca.R
\name{estimate.eig.vpcs}
\alias{estimate.eig.vpcs}
\title{Estimate the variance percentages for uncalculated eigenvalues}
\usage{
estimate.eig.vpcs(eigenv = NULL, min.dim = length(eigenv), M = NULL,
  elbow = NA, linear = TRUE, estimated = FALSE, print.est = TRUE,
  print.coef = FALSE, add.fit.line = FALSE, col = "blue",
  ignore.warn = FALSE)
}
\arguments{
\item{eigenv}{the vector of eigenvalues actually calculated}

\item{min.dim}{the size of the smaller dimension of the matrix submitted to singular
value decomposition, e.g, number of samples - i.e, the max number of possible eigenvalues,
alternatively use 'M'.}

\item{M}{optional enter the original dataset 'M'; simply used to derive the dimensions,
alternatively use 'min.dim'.}

\item{elbow}{the number of components which you think explain the important portion
of the variance of the dataset, so further components are assumed to be reflecting
noise or very subtle effects, e.g, often the number of components used is decided
by the 'elbow' in  a scree plot (see 'pca.scree.plot')}

\item{linear}{whether to use a linear model to model the 'noise' eigenvalues; alternative
is a 1/x model with no intercept.}

\item{estimated}{logical, whether to return the estimated variance percentages for unobserved eigenvalues
along with the real data; will also generate a factor describing which values in the returned
vector are observed versus estimated.}

\item{print.est}{whether to output the estimate result to the console}

\item{print.coef}{whether to output the estimate regression coefficients to the console}

\item{add.fit.line}{logical, if there is an existing scree plot, adds the fit line from this estimate
to the plot ('pca.scree.plot' can use this option using the parameter of the same name)}

\item{col}{colour for the fit line}

\item{ignore.warn}{ignore warnings when an estimate is not required (i.e, all eigenvalues present)}
}
\value{
By default returns a list where the first element ''variance.pcs' are the known variance
 percentages for each eigenvalue based on the estimated divisor, the second element
 'tail.auc' is the area under the curve for the estimated eigenvalues. If estimate
 =TRUE then a third element is return with separate variance percentages for
 each of the estimated eigenvalues.
}
\description{
If using a function like irlba() to calculate PCA, then you can choose (for speed) 
to only calculate a subset of the eigenvalues. So there is no exact percentage of variance explained 
by the PCA, or by each component as you will get as output from other routines.
This code uses a linear, or b*1/x model, to estimate the AUC for the unknown eigenvalues, providing
a reasonable estimate of the variances accounted for by each unknown eigenvalue, and
the predicted eigenvalue sum of the unknown eigenvalues.
}
\examples{
nsamp <- 100; nvar <- 300; subset.size <- 25; elbow <- 6
mat <- matrix(rnorm(nsamp*nvar),ncol=nsamp) 
# or use: # mat <- crimtab-rowMeans(crimtab) ; subset.size <- 10 # crimtab centred
prv.large(mat)
pca <- svd(mat,nv=subset.size,nu=0) # calculates subset of V, but all D
require(irlba)
pca2 <- irlba(mat,nv=subset.size,nu=0) # calculates subset of V & D
pca3 <- princomp(mat,cor=TRUE) # calculates all
# number of eigenvalues for svd is the smaller dimension of the matrix
eig.varpc <- estimate.eig.vpcs(pca$d^2,M=mat)$variance.pcs
cat("sum of all eigenvalue-variances=",sum(eig.varpc),"\\n")
print(eig.varpc[1:elbow])
# number of eigenvalues for irlba is the size of the subset if < min(dim(M))
eig.varpc <- estimate.eig.vpcs((pca2$d^2)[1:subset.size],M=mat)$variance.pcs
print(eig.varpc[1:elbow])  ## using 1/x model, underestimates total variance
eig.varpc <- estimate.eig.vpcs((pca2$d^2)[1:subset.size],M=mat,linear=TRUE)$variance.pcs
print(eig.varpc[1:elbow])  ## using linear model, closer to exact answer
eig.varpc <- estimate.eig.vpcs((pca3$sdev^2),M=mat)$variance.pcs
print(eig.varpc[1:elbow])  ## different analysis, but fairly similar var.pcs
}
\seealso{
\code{\link{pca.scree.plot}}
}
