% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/man-qq-gc.R
\name{snp_manhattan}
\alias{snp_manhattan}
\title{Manhattan plot}
\usage{
snp_manhattan(
  gwas,
  infos.chr,
  infos.pos,
  colors = c("black", "grey60"),
  dist.sep.chrs = 1e+07,
  ind.highlight = integer(0),
  col.highlight = "red",
  labels = NULL,
  npoints = NULL,
  coeff = 1
)
}
\arguments{
\item{gwas}{A \code{mhtest} object with the p-values associated with each SNP.
Typically, the output of \link[bigstatsr:big_univLinReg]{bigstatsr::big_univLinReg}, \link[bigstatsr:big_univLogReg]{bigstatsr::big_univLogReg}
or \link{snp_pcadapt}.}

\item{infos.chr}{Vector of integers specifying each SNP's chromosome.\cr
Typically \verb{<bigSNP>$map$chromosome}.}

\item{infos.pos}{Vector of integers specifying the physical position
on a chromosome (in base pairs) of each SNP.\cr
Typically \verb{<bigSNP>$map$physical.pos}.}

\item{colors}{Colors used for each chromosome (they are recycled).
Default is an alternation of black and gray.}

\item{dist.sep.chrs}{"Physical" distance that separates two chromosomes.
Default is 10 Mbp.}

\item{ind.highlight}{Indices of SNPs you want to highlight (of interest).
Default doesn't highlight any SNPs.}

\item{col.highlight}{Color used for highlighting SNPs. Default uses red.}

\item{labels}{Labels of the x axis. Default uses the number of the
chromosome there are in \code{infos.chr}(\code{sort(unique(infos.chr))}). This may be
useful to restrict the number of labels so that they are not overlapping.}

\item{npoints}{Number of points to keep (ranked by p-value) in order to get
a lighter object (and plot). Default doesn't cut anything.
If used, the resulting object will have an attribute called \code{subset}
giving the indices of the kept points.}

\item{coeff}{Relative size of text. Default is \code{1}.}
}
\value{
A \code{ggplot2} object. You can plot it using the \code{print} method.
You can modify it as you wish by adding layers. You might want to read
\href{https://r4ds.had.co.nz/data-visualisation.html}{this chapter}
to get more familiar with the package \strong{ggplot2}.
}
\description{
Creates a manhattan plot.
}
\details{
If you don't have information of chromosome and position, you should simply
use \code{plot} instead.
}
\examples{
set.seed(9)

test <- snp_attachExtdata()
G <- test$genotypes
y <- rnorm(nrow(G))

gwas <- big_univLinReg(G, y)

snp_qq(gwas)
gwas_gc <- snp_gc(gwas) # this modifies `attr(gwas_gc, "transfo")`
snp_qq(gwas_gc)

# The next plot should be prettier with a real dataset
snp_manhattan(gwas_gc,
              infos.chr = test$map$chromosome,
              infos.pos = test$map$physical.pos) +
  ggplot2::geom_hline(yintercept = -log10(5e-8), linetype = 2, color = "red")

p <- snp_qq(gwas_gc) +
  ggplot2::aes(text = asPlotlyText(test$map)) +
  ggplot2::labs(subtitle = NULL, x = "Expected -log10(p)", y = "Observed -log10(p)")
\dontrun{plotly::ggplotly(p, tooltip = "text")}
}
