% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lassosum2.R
\name{snp_lassosum2}
\alias{snp_lassosum2}
\title{lassosum2}
\usage{
snp_lassosum2(
  corr,
  df_beta,
  delta = signif(seq_log(0.001, 3, 6), 1),
  nlambda = 20,
  lambda.min.ratio = 0.01,
  dfmax = 2e+05,
  maxiter = 500,
  tol = 1e-05,
  ncores = 1
)
}
\arguments{
\item{corr}{Sparse correlation matrix as an \link[=SFBM-class]{SFBM}.
If \code{corr} is a dsCMatrix or a dgCMatrix, you can use \code{as_SFBM(corr)}.}

\item{df_beta}{A data frame with 3 columns:
\itemize{
\item \verb{$beta}: effect size estimates
\item \verb{$beta_se}: standard errors of effect size estimates
\item \verb{$n_eff}: sample size when estimating \code{beta}
(in the case of binary traits, this is \code{4 / (1 / n_control + 1 / n_case)})
}}

\item{delta}{Vector of shrinkage parameters to try (L2-regularization).
Default is \code{c(0.001, 0.005, 0.02, 0.1, 0.6, 3)}.}

\item{nlambda}{Number of different lambdas to try (L1-regularization).
Default is \code{20}.}

\item{lambda.min.ratio}{Ratio between last and first lambdas to try.
Default is \code{0.01}.}

\item{dfmax}{Maximum number of non-zero effects in the model.
Default is \code{200e3}.}

\item{maxiter}{Maximum number of iterations before convergence.
Default is \code{500}.}

\item{tol}{Tolerance parameter for assessing convergence.
Default is \code{1e-5}.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}
}
\value{
A matrix of effect sizes, one vector (column) for each row in
\verb{attr(<res>, "grid_param")}. Missing values are returned when strong
divergence is detected.
}
\description{
lassosum2
}
