% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{big_scale}
\alias{big_scale}
\title{Some scaling functions}
\usage{
big_scale(center = TRUE, scale = TRUE)
}
\arguments{
\item{center}{A logical value: whether to return means or 0s.}

\item{scale}{A logical value: whether to return sds or 1s. \strong{You can't
use scale without using center.}}
}
\value{
A new \strong{function} that returns a data.frame of two vectors
"center" and "scale" which are of the length of \code{ind.col}.
}
\description{
Some scaling functions for a Filebacked Big Matrix to be used as
the \strong{\code{fun.scaling}} parameter of some functions of this package.
}
\details{
One could think about less common scalings, such as for example the
"y-aware" scaling which uses the inverse of betas of column-wise linear
regression as scaling. See \href{https://goo.gl/8G8WMa}{this post} for details.
It would be easy to implement it using \code{big_colstats} to get column means
and \code{big_univLinReg} to get betas (and then inverse them).
}
\examples{
X <- big_attachExtdata()

# No scaling
big_noscale <- big_scale(center = FALSE, scale = FALSE)
class(big_noscale) # big_scale returns a new function
str(big_noscale(X))
big_noscale2 <- big_scale(center = FALSE)
str(big_noscale2(X)) # you can't scale without centering

# Centering
big_center <- big_scale(scale = FALSE)
str(big_center(X))
# + scaling
str(big_scale()(X))
}
\seealso{
\link{scale}
}
