% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier-dist.R
\name{prob_dist}
\alias{prob_dist}
\title{Probabilistic set distance}
\usage{
prob_dist(U, kNN = 5, robMaha = FALSE, ncores = 1)
}
\arguments{
\item{U}{A matrix, from which to detect outliers (rows). E.g. PC scores.}

\item{kNN}{Number of nearest neighbours to use. Default is \code{5}.}

\item{robMaha}{Whether to use a robust Mahalanobis distance instead of the
normal euclidean distance? Default is \code{FALSE}, meaning using euclidean.}

\item{ncores}{Number of cores to use. Default is \code{1}.}
}
\description{
Probabilistic set distance
}
\examples{
X <- readRDS(system.file("testdata", "three-pops.rds", package = "bigutilsr"))
svd <- svds(scale(X), k = 10)
U <- svd$u

test <- prob_dist(U)
plof <- test$dist.self / test$dist.nn
plof_ish <- test$dist.self / sqrt(test$dist.nn)
plot(U[, 1:2], col = (plof_ish > tukey_mc_up(plof_ish)) + 1, pch = 20)
plot(U[, 3:4], col = (plof_ish > tukey_mc_up(plof_ish)) + 1, pch = 20)
plot(U[, 5:6], col = (plof_ish > tukey_mc_up(plof_ish)) + 1, pch = 20)

}
\references{
Kriegel, Hans-Peter, et al. "LoOP: local outlier probabilities." Proceedings
of the 18th ACM conference on Information and knowledge management. ACM, 2009.
}
\seealso{
\code{\link[=LOF]{LOF()}} \code{\link[=to_maha]{to_maha()}}
}
